(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5728,        178]*)
(*NotebookOutlinePosition[      6374,        200]*)
(*  CellTagsIndexPosition[      6330,        196]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Evaluate everything in this notebook...", "Text"],

Cell[BoxData[
    \(\(fa = {{1, 1} \[Rule] {1, 0}, {1, 0} \[Rule] {2, 1}, {2, 
              1} \[Rule] {2, 1}, {2, 0} \[Rule] {1, 0}};\)\)], "Input"],

Cell[BoxData[
    \(FAApply[rule_, init_, list_] := 
      FoldList[{First[#1], #2} /. rule &, {init}, list]\)], "Input"],

Cell[BoxData[
    \(FAApply[rule_, s0_, list_] := 
      FoldList[{First[#1], #2} /. rule &, {s0}, list]\)], "Input"],

Cell[BoxData[
    \(FAStep[rule_, s0_, list_] := 
      Map[Last, 
        Rest[FoldList[{First[#1], #2} /. rule &, {s0}, list]]]\)], "Input"],

Cell[BoxData[
    \(FAEvolveList[rule_, s0_, init_, t_] := 
      NestList[FAStep[rule, s0, #] &, init, t]\)], "Input"],

Cell[BoxData[
    \(RasterGraphics[data_] := 
      Graphics[Raster[1 - Reverse[data]], 
        AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[BoxData[
    \(RasterGraphics[data_, lab_] := 
      Graphics[Raster[1 - Reverse[data]], AspectRatio \[Rule] Automatic, 
        PlotLabel \[Rule] lab]\)], "Input"],

Cell[BoxData[
    \(\(Show[
        RasterGraphics[
          FAEvolveList[fa, 1, Table[0, {100}], 60]]];\)\)], "Input"],

Cell[BoxData[
    \(ToFARule[n_Integer, {s_Integer, k_Integer}] := 
      Flatten[MapIndexed[{1, \(-1\)} #2 + {0, k} \[Rule] 
              Mod[Quotient[#1, {k, 1}], {s, k}] + {1, 0} &, 
          Partition[IntegerDigits[n, s\ k, s\ k], k], {2}]]\)], "Input"],

Cell[BoxData[
    \(RasterGraphics[data_, lab_] := 
      Graphics[Raster[1 - Reverse[data]], AspectRatio \[Rule] Automatic, 
        PlotLabel \[Rule] lab]\)], "Input"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[
          Partition[
            Table[RasterGraphics[
                FAEvolveList[ToFARule[i, {2, 2}], 1, Table[0, {40}], 30], 
                i], {i, 0, 255}], 8]]];\)\)], "Input"],

Cell[BoxData[
    \(FAMap[rule_, s0_, n_, k_:  2] := 
      Table[{i, FromDigits[FAStep[rule, s0, IntegerDigits[i, k, n]], k]}, {i, 
          0, k^n - 1}]\)], "Input"],

Cell[BoxData[
    \(FAMapMatrix[rule_, s0_, n_, k_:  2] := 
      Normal[SparseArray[\(\((\((# + 1)\) \[Rule] 1)\) &\) /@ 
            FAMap[rule, s0, n], {k^n, k^n}]]\)], "Input"],

Cell[BoxData[
    \(\(Show[RasterGraphics[FAMapMatrix[fa, 1, 8]]];\)\)], "Input"],

Cell["A simple heuristic to find \"interesting\" cases:", "Text"],

Cell[BoxData[
    \(\(icases = 
        Select[Range[6^6] - 1, 
          With[{u = ToFARule[#, {3, 2}]}, 
              Length[Union[
                    Split[Nest[FAStep[u, 1, #] &, Table[0, {15}], 5]]]] > 
                3] &];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[
          Partition[\(RasterGraphics[
                  FAEvolveList[ToFARule[#, {3, 2}], 1, Table[0, {40}], 
                    30], #] &\) /@ Take[icases, 100], 8]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[
          Partition[\(RasterGraphics[
                  FAEvolveList[ToFARule[#, {3, 2}], 1, Table[0, {40}], 
                    30], #] &\) /@ Take[icases, {200, 300}], 
            8]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[
          Partition[\(RasterGraphics[
                  FAEvolveList[ToFARule[#, {3, 2}], 1, Table[0, {40}], 
                    30], #] &\) /@ Take[icases, {2000, 2100}], 
            8]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        RasterGraphics[
          FAEvolveList[ToFARule[5046, {3, 2}], 1, Table[0, {400}], 
            300]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        RasterGraphics[
          FAEvolveList[ToFARule[5058, {3, 2}], 1, Table[0, {400}], 
            300]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        RasterGraphics[
          FAEvolveList[ToFARule[5131, {3, 2}], 1, Table[0, {400}], 
            300]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        RasterGraphics[
          FAEvolveList[ToFARule[28126, {3, 2}], 1, Table[0, {400}], 
            300]]];\)\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{1033, 951},
WindowMargins->{{99, Automatic}, {11, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 55, 0, 33, "Text"],
Cell[1812, 53, 150, 2, 30, "Input"],
Cell[1965, 57, 121, 2, 30, "Input"],
Cell[2089, 61, 117, 2, 30, "Input"],
Cell[2209, 65, 142, 3, 30, "Input"],
Cell[2354, 70, 119, 2, 30, "Input"],
Cell[2476, 74, 140, 3, 30, "Input"],
Cell[2619, 79, 169, 3, 30, "Input"],
Cell[2791, 84, 120, 3, 30, "Input"],
Cell[2914, 89, 259, 4, 50, "Input"],
Cell[3176, 95, 169, 3, 30, "Input"],
Cell[3348, 100, 235, 6, 30, "Input"],
Cell[3586, 108, 168, 3, 30, "Input"],
Cell[3757, 113, 180, 3, 30, "Input"],
Cell[3940, 118, 81, 1, 30, "Input"],
Cell[4024, 121, 65, 0, 33, "Text"],
Cell[4092, 123, 247, 6, 30, "Input"],
Cell[4342, 131, 235, 5, 30, "Input"],
Cell[4580, 138, 255, 6, 50, "Input"],
Cell[4838, 146, 257, 6, 50, "Input"],
Cell[5098, 154, 154, 4, 30, "Input"],
Cell[5255, 160, 154, 4, 30, "Input"],
Cell[5412, 166, 154, 4, 30, "Input"],
Cell[5569, 172, 155, 4, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

